/*
#pragma GCC optimize("Ofast,unroll-loops")
#pragma GCC target("avx2,tune=native")
*/

#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
typedef int64_t ll;
typedef uint64_t ull;

struct event {
    bool res;
    ll day;
    ll num;
    event() {}
    event(bool res, ll day, ll num) : num(num), day(day), res(res) {}
};

ll n;
vector<ll> a, b, c;
vector<event> evs;
vector<bool> passed;

ll solve(ll cur_ev = 0, ll last_day = 0) {
    if (cur_ev == 2 * n) {
        return last_day;
    }
    if (passed[evs[cur_ev].num]) {
        return solve(cur_ev + 1, last_day);
    }
    if (evs[cur_ev].res) {
        ll result;
        if (evs[cur_ev].day - last_day - 1 >= c[evs[cur_ev].num]) {
            passed[evs[cur_ev].num] = true;
            result = solve(cur_ev + 1, evs[cur_ev].day);
            if (result != -1)
                return result;
            passed[evs[cur_ev].num] = false;
        }
        return solve(cur_ev + 1, last_day);
    } else {
        if (evs[cur_ev].day - last_day - 1 < c[evs[cur_ev].num])
            return -1;
        passed[evs[cur_ev].num] = true;
        ll res = solve(cur_ev + 1, evs[cur_ev].day);
        if (res == -1)
            passed[evs[cur_ev].num] = false;
        return res;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> n;
    a.resize(n);
    b.resize(n);
    c.resize(n);
    for (ll i = 0; i < n; ++i) {
        cin >> a[i] >> b[i] >> c[i];
    }
    passed.assign(n, false);
    evs.reserve(2 * n);
    for (ll i = 0; i < n; ++i) {
        evs.push_back(event(0, a[i], i));
        evs.push_back(event(1, b[i], i));
    }
    sort(evs.begin(), evs.end(), [](event a, event b) {
        return a.day < b.day || (a.day == b.day && a.res > b.res);
    });
    cout << solve();
}
